<?php
session_start();
include '../../inc.php';

header('Access-Control-Allow-Origin: *');
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: X-Requested-With, Origin, Content-Type, X-Auth-Token , Authorization");
$ini = parse_ini_file('../../app.ini');

if(!empty($_GET['config'])) {
    die(json_encode(['login' => $ini['login_required']]));
}
if ($_SERVER['REQUEST_METHOD'] === 'POST' || $_SERVER['REQUEST_METHOD'] === 'GET') {

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, "http://".$ini['server_ip']."/api/netflix/".$_GET["path"]."/".$_SESSION['session_id']);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, file_get_contents('php://input'));
    }
    $headers = array();
    $headers[] = 'Connection: keep-alive';
    $headers[] = 'Pragma: no-cache';
    $headers[] = 'Cache-Control: no-cache';
    $headers[] = 'Accept: application/json, text/plain, */*';
    $headers[] = 'Authorization: Bearer '.$ini['token'];
    $headers[] = 'User-Agent: '.$_SERVER["HTTP_USER_AGENT"];
    $headers[] = 'Content-Type: application/json;charset=UTF-8';
    $headers[] = 'Origin: '.$_SERVER["HTTP_ORIGIN"];
    $headers[] = 'Referer: '.$_SERVER["HTTP_REFERER"];
    $headers[] = 'Accept-Language: '.$_SERVER["HTTP_ACCEPT_LANGUAGE"];
    $headers[] = 'Vicitm-Ip: ' . get_client_ip();
    $headers[] = 'App-Version: ' . $ini['version'];

    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    $result = curl_exec($ch);
    http_response_code(curl_getinfo($ch, CURLINFO_HTTP_CODE));
    echo $result;
}
